Spot = copy_table(Bitmap)
Spot.is_spot = true


function Spot:new(def, view)
    local o = copy_table(self)
    o:init(def, view)
    return o
end


function Spot:init(def, view)
    Bitmap.init(self, def, view)
    self:create_area(def.area)
end


function Spot:mouse_left_click()
    if self.has_stack == nil and self.state == "deck" then
        self.view:turn_over_deck()
        snd_play_sound("deck_turn")
    end
end


function Spot:accepts_stack(card)
    if self.state == "home" and card.value == 1 and not card.has_stack then
        return true
    elseif self.state == "table" and card.value == 13 then
        return true
    end
    return false
end


function Spot:stack_position()
    if self.state == "table" then
        return self.x, self.y, self.z + 1
    elseif self.state == "home" then
        return self.x, self.y, self.z + 1
    end
end
